/** @file   storyviewer.h
 * @brief   Declaration of StoryViewer - class
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_STORYVIEWER_H
#define H_WWW_STORYVIEWER_H

#include <string>

struct BITMAP;

namespace WeWantWar {


/** @class  StoryViewer
 * @brief   Shows the level stories at the begining of the level.
 * @author  Tomi Lamminsaari
 *
 */
class StoryViewer
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	StoryViewer();


	/** Destructor
   */
	virtual ~StoryViewer();

private:

	/** Copy constructor.
   * @param     rO                Reference to another StoryViewer
   */
  StoryViewer( const StoryViewer& rO );

	/** Assignment operator
   * @param     rO                Reference to another StoryViewer
   * @return    Reference to us.
   */
  StoryViewer& operator = ( const StoryViewer& rO );

public:



  ///
  /// Methods
  /// =======

  /** Shows the level story
   * @param     aBackground       Name of the background picture file
   * @param     aStoryFile        Name of the story picture file
   * @return    Nonzero if no errors was encountered.
   */
  int showStory( const std::string& aBackground,
                 const std::string& aStoryFile );
  


  ///
  /// Getter methods
  /// ==============


protected:

  /** Shows the story scroll
   * @param     aBackground       Pointer to background image
   * @param     aStory            Pointer to story image
   */
  void storyScroll( BITMAP* aBackground, BITMAP* aStory );
  
  
  
  ///
  /// Members
  /// =======



private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: storyviewer.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:17+02  lamminsa
 * Initial revision
 *
 */
 
